#include "NumberLine.h"
#include <QtGui>
#include <QTextCursor>

/*=======================================================
// NumberLine - 
========================================================*/
NumberLine::NumberLine( QWidget *parent )
    : QWidget( parent ), edit(0), m_currentLine(-1)
{
    // Mark Position
    setFixedWidth( fontMetrics().width( QString("000") + 10 + 32 ) );
	// Mark
    stopMarker = QPixmap( "images/no.png" );
}

/*=======================================================
// NumberLine - Ҹ
========================================================*/
NumberLine::~NumberLine()
{
}

/*=======================================================
// NumberLine -  
========================================================*/
void NumberLine::setCurrentLine( int lineno )
{
    m_currentLine = lineno;
}


/*=======================================================
// NumberLine - Breakpoint make
========================================================*/
void NumberLine::setBreakpoint( int lineno )
{
	list << lineno;
	this->repaint();
}

/*=======================================================
// NumberLine - All Breakpoint delete
========================================================*/
void NumberLine::AllBreakpointClear()
{
	list.clear();
	this->repaint();
}

/*=======================================================
// NumberLine - Breakpoint delete
========================================================*/
void NumberLine::BreakpointClear(int lineno)
{
	for(int i=0; i< list.count(); i++)
	{
		if(list.at(i) == lineno)
		{
			list.removeAt(i);
		}
	}
	this->repaint();
}

/*=======================================================
// NumberLine(ٹȣ) - Text Update
========================================================*/
void NumberLine::setTextEdit( QTextEdit *edit )
{
    this->edit = edit;
    connect( edit->document()->documentLayout(), SIGNAL( update(const QRectF &) ),this, SLOT( repaint() ) );
    connect( edit->verticalScrollBar(), SIGNAL(valueChanged(int) ),this, SLOT( repaint() ) );
}

/*=======================================================
// NumberLine(ũ) - Mark create
========================================================*/
void NumberLine::paintEvent( QPaintEvent * )
{
    QAbstractTextDocumentLayout *layout = edit->document()->documentLayout();
    int contentsY = edit->verticalScrollBar()->value();
    qreal pageBottom = contentsY + edit->viewport()->height();
    const QFontMetrics fm = fontMetrics();
    const int ascent = fontMetrics().ascent() + 1; // height = ascent + descent + 1
    
	int lineCount = 1;
	
    QPainter p(this);

  //  stopRect = QRect();
    
    for ( QTextBlock block = edit->document()->begin(); block.isValid(); block = block.next(), ++lineCount)
	{
        QRectF boundingRect = layout->blockBoundingRect( block );
		QPointF position = boundingRect.topLeft();
        if ( position.y() + boundingRect.height() < contentsY )
            continue;
        if ( position.y() > pageBottom )
            break;

        const QString txt = QString::number( lineCount );
        p.drawText( width() - fm.width(txt), qRound( position.y() ) - contentsY + ascent, txt );
	
		// Stop marker
		for(int i=0 ;i < list.count(); i++)
		{
			if ( list[i] == lineCount )
			{
				p.drawPixmap( 1, qRound( position.y() ) - contentsY, stopMarker );
				stopRect[i] = QRect( 1, qRound( position.y() ) - contentsY, stopMarker.width(), stopMarker.height() );
			}
		}
	} 
}

/*=======================================================
// NumberLine() - Mark Event
========================================================*/
bool NumberLine::event( QEvent *event )
{
    if ( event->type() == QEvent::ToolTip ) 
	{
		QHelpEvent *helpEvent = static_cast<QHelpEvent *>(event);
		for( int i = 0; i< list.count(); i++)
		{
			if ( stopRect[i].contains( helpEvent->pos() ) ) 
			{
				QToolTip::showText( helpEvent->globalPos(), "Stop Here" );
			}
		}
	}
    return QWidget::event(event);
}


